<?php
namespace SotaStudio\Flexslider\Controller;
/***************************************************************
 *  Copyright notice
 *
 *  (c) 2012-2014 Andy Hausmann <ah@sota-studio.de>, SOTA Studio
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

use SotaStudio\Flexslider\Domain\Repository\FlexSliderRepository,
	SotaStudio\Flexslider\Utility\EmConfiguration,
	TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface,
	TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

/**
 * Main Controller.
 *
 * @author Andy Hausmann <ah@sota-studio.de>, SOTA Studio
 * @package flexslider
 * @subpackage Controller
 */
class FlexSliderController extends ActionController {

	/** @var \TYPO3\CMS\Frontend\Controller\TypoScriptFrontendController */
	protected $TSFE;

	/** @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer */
	protected $contentObject;

	/**
	 * flexSliderRepository
	 *
	 * @var \SotaStudio\Flexslider\Domain\Repository\FlexSliderRepository
	 */
	protected $flexSliderRepository;


	/**
	 * injectFlexSliderRepository
	 *
	 * @param \SotaStudio\Flexslider\Domain\Repository\FlexSliderRepository $flexSliderRepository
	 * @return void
	 */
	public function injectFlexSliderRepository(FlexSliderRepository $flexSliderRepository) {
		$this->flexSliderRepository = $flexSliderRepository;
	}

	/**
	 * Kinda constructor
	 * Beeing executed right after __construct and has access to injected Objects
	 *
	 * @return void
	 */
	public function initializeAction() {
		$this->contentObject = $this->configurationManager->getContentObject();
		$this->TSFE =& $GLOBALS['TSFE'];

		// Fallback to current pid if no storagePid is defined
		$configuration = $this->configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK);
		if(empty($configuration['persistence']['storagePid'])){
			$currentPid['persistence']['storagePid'] = $this->TSFE->id;
			$this->configurationManager->setConfiguration(array_merge($configuration, $currentPid));
		}
	}

	/**
	 * Action list
	 * Displays all slider elements.
	 *
	 * @return void
	 */
	public function listAction() {
		$flexSliders = $this->flexSliderRepository->findAll();

		$tplObj = array(
			'configuration' => EmConfiguration::getConfiguration(),
			'data' => $this->contentObject->data,
			'altUid' => uniqid('alt'),
			'flexSliders' => $flexSliders
		);
		$this->view->assignMultiple($tplObj);
	}

}